@echo off
chcp 65001 >nul
title WizStudio Status Server

echo ===============================
echo  启动 WizStudio Status 服务
echo ===============================
echo.

REM 检查配置文件是否存在
if not exist "wizstudio_status.conf" (
    echo 错误: 未找到配置文件 wizstudio_status.conf
    echo 请先运行安装脚本进行安装。
    echo.
    pause
    exit /b 1
)

REM 检查服务程序是否存在
if not exist "server.py" (
    echo 错误: 未找到服务程序 server.py
    echo 请先运行安装脚本进行安装。
    echo.
    pause
    exit /b 1
)

REM 检查Python是否可用
python --version >nul 2>&1
if errorlevel 1 (
    echo 错误: Python未安装或不在PATH中
    echo 请安装Python 3.7或更高版本。
    echo.
    pause
    exit /b 1
)

echo 正在启动WizStudio Status服务...
echo 提示: 按 Ctrl+C 可以停止服务
echo.

REM 启动服务
python server.py

echo.
echo 服务已停止。
pause