# WizStudio Status - Windows版本

Windows服务器监控与API服务脚本，提供与Linux版本相同的功能和API端点。

## 功能特性

- **系统监控**: CPU信息、使用率、内存、磁盘、网络IO
- **API服务**: HTTP API接口，返回JSON格式数据
- **安全认证**: UUID + Token双重验证
- **诊断模式**: 详细的系统诊断信息
- **易于部署**: PowerShell脚本，无需复杂配置

## 系统要求

- Windows 10/11 或 Windows Server 2016+
- PowerShell 5.0+
- Python 3.7+ (脚本会检查并提示安装)

## 快速开始

### 方法1: 使用启动脚本 (推荐，自动处理执行策略)

1. 右键点击 `start.ps1` → "使用PowerShell运行"
2. 或双击运行 `run.bat`
3. 按照提示完成安装配置
4. 选择"启动服务"开始运行

### 方法2: 手动处理执行策略后运行

```powershell
# 临时绕过执行策略 (推荐)
powershell -ExecutionPolicy Bypass -File .\status_vps.ps1

# 或永久更改执行策略 (需要管理员权限)
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope LocalMachine
.\status_vps.ps1
```

### 方法3: 命令行参数

```powershell
# 直接安装
powershell -ExecutionPolicy Bypass -File .\status_vps.ps1 -Action install

# 启动服务
powershell -ExecutionPolicy Bypass -File .\status_vps.ps1 -Action start
```

## 安装步骤

1. **运行安装脚本**
   - 双击 `run.bat` 或在PowerShell中运行 `.\status_vps.ps1`

2. **选择安装选项**
   - 选择 "1) 安装（默认）"

3. **配置参数**
   - 服务端口 (默认: 8008)
   - Token (自定义认证密钥)
   - 备注信息
   - 网络接口 (从可用网卡中选择)

4. **完成安装**
   - 脚本会自动安装Python依赖 (psutil)
   - 生成配置文件和服务程序

## 🚀 快速启动服务

**安装完成后必须启动服务才能使用API！**

### 最简单的启动方法：
```
双击 start_server.cmd
```

### 或者使用命令行：
```cmd
python server.py
```

### 验证服务运行：
看到以下输出表示服务启动成功：
```
WizStudio Status Server started on port 8008
```

### 测试API：
在浏览器中访问（替换YOUR_UUID和YOUR_TOKEN）：
```
http://localhost:8008/cpu/info?uuid=YOUR_UUID&token=YOUR_TOKEN
```

## API端点

所有API请求需要包含 `uuid` 和 `token` 参数：

```
http://IP:PORT/endpoint?uuid=YOUR_UUID&token=YOUR_TOKEN
```

### 可用端点

| 端点 | 功能 | 返回示例 |
|------|------|----------|
| `/cpu/info` | CPU信息 | `"Intel Core i7-9700K 8Cores@3.60GHz"` |
| `/cpu/usage` | CPU使用率 | `"25.3%"` |
| `/ram/usage0` | 内存使用量 | `"8.50GB/16.00GB"` |
| `/ram/usage1` | 内存使用率 | `"53.1%"` |
| `/disk/usage0` | 磁盘使用量 | `"120.5GB/500.0GB"` |
| `/disk/usage1` | 磁盘使用率 | `"24.1%"` |
| `/disk/io` | 磁盘IO | `{"read":"1.25MB/s","write":"0.80MB/s","read_iops":45,"write_iops":32}` |
| `/network/status` | 网络状态 | `"15.20Mbps/8.50Mbps"` (上传/下载) |
| `/time` | 系统运行时间 | `"2日5小时30分钟"` |

### 诊断端点

```
http://IP:PORT/diagnostic?uuid=YOUR_UUID&token=YOUR_TOKEN&diagnostic=1
```

返回详细的系统诊断信息，用于故障排查。

## 服务管理

### 启动服务

**重要**: 安装完成后，需要手动启动服务才能访问API！

#### 方法1: 使用启动脚本 (推荐)
```cmd
# 双击运行
start_server.cmd
```

#### 方法2: 使用PowerShell菜单
```powershell
.\status_vps.ps1
# 选择 "2) Start Service"
```

#### 方法3: 直接启动
```cmd
# 在命令行中运行
python server.py
```

#### 方法4: 后台启动 (PowerShell)
```powershell
# 启动后台作业
Start-Process python -ArgumentList "server.py" -WindowStyle Hidden
```

### 验证服务运行

启动服务后，你应该看到类似输出：
```
WizStudio Status Server started on port 8008
```

然后可以测试API访问：
```
http://localhost:8008/cpu/info?uuid=YOUR_UUID&token=YOUR_TOKEN
```

### 后台运行

推荐使用以下方法之一在后台运行服务：

#### 1. 使用NSSM (推荐)

```cmd
# 下载并安装NSSM
# https://nssm.cc/download

# 创建Windows服务
nssm install WizStudioStatus
# 设置程序路径: python.exe
# 设置参数: C:\path\to\server.py
# 设置工作目录: C:\path\to\script\directory

# 启动服务
nssm start WizStudioStatus
```

#### 2. 使用任务计划程序

1. 打开"任务计划程序"
2. 创建基本任务
3. 设置触发器为"计算机启动时"
4. 操作设置为运行 `python server.py`

#### 3. 使用PowerShell后台作业

```powershell
# 启动后台作业
Start-Job -ScriptBlock { python server.py }

# 查看作业状态
Get-Job

# 停止作业
Stop-Job -Name Job1
```

## 配置文件

配置文件 `wizstudio_status.conf` 包含以下设置：

```
PORT=8008
UUID=xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
TOKEN=your_secret_token
IFACE=以太网
COMMENT=Default
```

## 故障排查

### 常见问题

1. **PowerShell执行策略限制 / 数字签名问题**
   
   **问题现象**: "无法加载文件，未对文件进行数字签名，无法在当前系统下运行该脚本"
   
   **解决方案** (按推荐顺序):
   
   **方案A: 使用启动脚本 (最简单)**
   ```
   右键点击 start.ps1 → "使用PowerShell运行"
   ```
   
   **方案B: 临时绕过策略 (推荐)**
   ```powershell
   # 临时绕过，不改变系统设置
   powershell -ExecutionPolicy Bypass -File .\status_vps.ps1
   ```
   
   **方案C: 更改当前会话策略**
   ```powershell
   # 仅对当前PowerShell会话有效
   Set-ExecutionPolicy -ExecutionPolicy Bypass -Scope Process
   .\status_vps.ps1
   ```
   
   **方案D: 永久更改策略 (需要管理员权限)**
   ```powershell
   # 以管理员身份运行PowerShell
   Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope LocalMachine
   .\status_vps.ps1
   ```
   
   **方案E: 解除文件阻止**
   ```powershell
   # 如果文件被Windows标记为来自Internet
   Unblock-File .\status_vps.ps1
   Unblock-File .\start.ps1
   ```

2. **Python未安装**
   - 下载并安装Python: https://www.python.org/downloads/
   - 确保勾选"Add Python to PATH"

3. **psutil安装失败**
   ```cmd
   pip install psutil
   ```

4. **端口被占用**
   ```cmd
   # 检查端口占用
   netstat -ano | findstr :8008
   
   # 更改端口
   # 运行脚本选择"4) 更改Token"，然后手动编辑配置文件修改PORT
   ```

5. **防火墙阻止**
   - 在Windows防火墙中添加端口例外
   - 或临时关闭防火墙测试

### 诊断模式

使用诊断模式获取详细的系统信息：

```powershell
# 运行脚本选择"6) 运行诊断"
.\status_vps.ps1
```

或直接访问诊断API：
```
http://localhost:8008/diagnostic?uuid=YOUR_UUID&token=YOUR_TOKEN&diagnostic=1
```

## 安全注意事项

1. **Token安全**: 使用强密码作为Token，定期更换
2. **网络访问**: 建议配置防火墙规则限制访问来源
3. **HTTPS**: 生产环境建议使用反向代理配置HTTPS
4. **权限控制**: 避免使用管理员权限运行服务

## 更新日志

### v1.0.0 (2025-01-03)
- 初始版本发布
- 支持所有Linux版本的API端点
- Windows系统适配
- 诊断功能
- PowerShell脚本界面

## 许可证

本项目遵循与Linux版本相同的许可证。

## 技术支持

如遇问题，请提供以下信息：
1. Windows版本
2. PowerShell版本
3. Python版本
4. 错误信息截图
5. 诊断模式输出